import { jsx, jsxs } from "react/jsx-runtime";
import { C as CategoryCard3 } from "./category-card-4-CN97J7iF.js";
import { g as getPageSection, S as Section } from "./section-DVceEJ6r.js";
import { k as getColorWithOpacity } from "./utils-Dq7odfJT.js";
import { usePage } from "@inertiajs/react";
import "./card-DBOrqCcU.js";
import "react";
import "lucide-react/dynamic";
import "./dialog-Bzzm0V8u.js";
import "@radix-ui/react-dialog";
import "lucide-react";
import "./use-lang-44ndmTOc.js";
import "./chunked-uploader-input-DSIqX-Yc.js";
import "./button-CoRGprmX.js";
import "@radix-ui/react-slot";
import "class-variance-authority";
import "./input-BPdrsFAc.js";
import "axios";
import "sonner";
import "./input-error-CBKwRgzN.js";
import "./loading-button-C9msud_X.js";
import "./label-BKAgVFnB.js";
import "@radix-ui/react-label";
import "./textarea-M8ToDCeU.js";
import "./inertia-BtwbgBI3.js";
import "./icon-picker-dialog-kwu88Bla.js";
import "./icon-picker-CUJAUhoK.js";
import "./debounce-ZFxqVthq.js";
import "./tooltip-BatcEs-T.js";
import "@radix-ui/react-tooltip";
import "./scroll-area-Dgj2o23v.js";
import "@radix-ui/react-scroll-area";
import "./table-header-BdDXN7Km.js";
import "./table-Lb16Ctse.js";
import "@tanstack/react-table";
import "./table-page-size-CjbVFJnO.js";
import "./dropdown-menu-DONmDWr6.js";
import "@radix-ui/react-dropdown-menu";
import "./route-DlE7FdTW.js";
import "./avatar-DPWl5zBC.js";
import "@radix-ui/react-avatar";
import "clsx";
import "tailwind-merge";
const TopCategories = () => {
  const { props } = usePage();
  const { page, customize, topCategories } = props;
  const topCategoriesSection = getPageSection(page, "top_categories");
  const colors = [
    "rgba(79,57,246,1)",
    "rgba(0,122,85,1)",
    "rgba(255,171,0,1)",
    "rgba(236,0,63,1)",
    "rgba(255,171,0,1)"
    // 'rgba(236,0,63,1)',
    // 'rgba(79,57,246,1)',
    // 'rgba(0,122,85,1)',
  ];
  return /* @__PURE__ */ jsx(Section, { customize, pageSection: topCategoriesSection, containerClass: "mt-20 py-20", contentClass: "relative", children: /* @__PURE__ */ jsxs("div", { className: "relative z-10 flex flex-col items-center justify-between gap-8 md:flex-row", children: [
    /* @__PURE__ */ jsxs("div", { className: "w-full md:max-w-[306px]", children: [
      /* @__PURE__ */ jsx("h2", { className: "mb-2 text-3xl font-bold sm:text-4xl", children: topCategoriesSection == null ? void 0 : topCategoriesSection.title }),
      /* @__PURE__ */ jsx("p", { className: "text-muted-foreground", children: topCategoriesSection == null ? void 0 : topCategoriesSection.description })
    ] }),
    /* @__PURE__ */ jsx("div", { className: "z-10 grid w-full grid-cols-1 gap-7 md:grid-cols-2 lg:grid-cols-3", children: topCategories.map((category, index) => {
      const colorIndex = index % colors.length;
      const currentColor = colors[colorIndex];
      return /* @__PURE__ */ jsx(
        CategoryCard3,
        {
          category,
          style: {
            color: currentColor,
            borderColor: getColorWithOpacity(currentColor, 0.15),
            backgroundColor: getColorWithOpacity(currentColor, 0.04)
          }
        },
        category.id
      );
    }) })
  ] }) });
};
export {
  TopCategories as default
};
